import { Card } from "@/components/ui/card";
import { Badge } from "@/components/ui/badge";
import { Target, Award, Users, Globe, Heart, Lightbulb } from "lucide-react";

export default function AboutPage() {
  return (
    <div className="pt-20">
      <section className="bg-gradient-to-br from-emerald-50 to-blue-50 py-20 px-4">
        <div className="max-w-4xl mx-auto text-center">
          <Badge className="mb-6 bg-emerald-100 text-emerald-700">Hakkımızda</Badge>
          <h1 className="text-5xl md:text-6xl font-bold mb-6">Ucuza Vize</h1>
          <p className="text-xl text-gray-600 leading-relaxed">
            2015 yılından beri binlerce öğrencinin yurtdışı eğitim hayallerini gerçeğe dönüştürüyoruz.
            Güvenilir, profesyonel ve uygun fiyatlı hizmetimizle yanınızdayız.
          </p>
        </div>
      </section>

      <section className="py-16 px-4 bg-white">
        <div className="max-w-6xl mx-auto">
          <div className="grid md:grid-cols-2 gap-12 items-center mb-16">
            <div>
              <h2 className="text-4xl font-bold mb-6">Misyonumuz</h2>
              <p className="text-gray-600 text-lg leading-relaxed mb-6">
                Yurtdışında eğitim almak isteyen her bireye, en kaliteli hizmeti en uygun fiyatlarla
                sunarak hayallerini gerçekleştirmelerine yardımcı olmak.
              </p>
              <p className="text-gray-600 text-lg leading-relaxed">
                Müşterilerimize sadece vize ve dil okulu hizmeti değil, aynı zamanda güvenilir bir
                partner olarak her adımda destek sağlamak ana hedefimizdir.
              </p>
            </div>
            <div className="bg-gradient-to-br from-emerald-100 to-blue-100 rounded-2xl p-12 text-center">
              <div className="text-6xl mb-4">🎓</div>
              <div className="text-4xl font-bold text-emerald-600 mb-2">10 Yıl</div>
              <div className="text-gray-700 font-medium">Tecrübe</div>
            </div>
          </div>

          <div className="grid md:grid-cols-3 gap-8 mb-16">
            {[
              {
                icon: Target,
                title: "Vizyonumuz",
                description: "Türkiye'nin en güvenilir ve tercih edilen uluslararası eğitim danışmanlık platformu olmak"
              },
              {
                icon: Heart,
                title: "Değerlerimiz",
                description: "Dürüstlük, şeffaflık, müşteri memnuniyeti ve profesyonellik"
              },
              {
                icon: Lightbulb,
                title: "Yaklaşımımız",
                description: "Her öğrenciye özel çözümler sunarak en iyi sonuçları elde etmek"
              }
            ].map((item, idx) => (
              <Card key={idx} className="p-8 text-center hover:shadow-xl transition-shadow border-2">
                <item.icon className="h-12 w-12 text-emerald-600 mx-auto mb-4" />
                <h3 className="text-xl font-bold mb-3">{item.title}</h3>
                <p className="text-gray-600 leading-relaxed">{item.description}</p>
              </Card>
            ))}
          </div>
        </div>
      </section>

      <section className="py-16 px-4 bg-gray-50">
        <div className="max-w-6xl mx-auto">
          <h2 className="text-4xl font-bold mb-12 text-center">Neden Bizi Seçmelisiniz?</h2>
          <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-8">
            {[
              { icon: Award, title: "Tecrübeli Ekip", value: "10+ Yıl", desc: "Sektör deneyimi" },
              { icon: Users, title: "Mutlu Öğrenci", value: "5000+", desc: "Başarılı başvuru" },
              { icon: Globe, title: "Ülke Çeşitliliği", value: "50+", desc: "Farklı destinasyon" },
              { icon: Award, title: "Başarı Oranı", value: "%98", desc: "Vize onay oranı" }
            ].map((stat, idx) => (
              <Card key={idx} className="p-8 text-center hover:shadow-xl transition-shadow">
                <stat.icon className="h-12 w-12 text-emerald-600 mx-auto mb-4" />
                <h3 className="font-bold mb-2">{stat.title}</h3>
                <div className="text-3xl font-bold text-emerald-600 mb-2">{stat.value}</div>
                <p className="text-sm text-gray-600">{stat.desc}</p>
              </Card>
            ))}
          </div>
        </div>
      </section>

      <section className="py-16 px-4 bg-white">
        <div className="max-w-6xl mx-auto">
          <h2 className="text-4xl font-bold mb-12 text-center">Ekibimiz</h2>
          <div className="grid md:grid-cols-3 gap-8">
            {[
              { name: "Ahmet Yılmaz", role: "Kurucu & CEO", experience: "15 yıl deneyim" },
              { name: "Ayşe Demir", role: "Vize Danışmanı", experience: "10 yıl deneyim" },
              { name: "Mehmet Kaya", role: "Eğitim Danışmanı", experience: "8 yıl deneyim" }
            ].map((member, idx) => (
              <Card key={idx} className="p-8 text-center hover:shadow-xl transition-shadow">
                <div className="w-24 h-24 bg-gradient-to-r from-emerald-600 to-blue-600 rounded-full mx-auto mb-4 flex items-center justify-center text-white text-2xl font-bold">
                  {member.name.split(' ').map(n => n[0]).join('')}
                </div>
                <h3 className="text-xl font-bold mb-2">{member.name}</h3>
                <p className="text-emerald-600 font-medium mb-2">{member.role}</p>
                <p className="text-sm text-gray-600">{member.experience}</p>
              </Card>
            ))}
          </div>
        </div>
      </section>

      <section className="py-16 px-4 bg-gradient-to-r from-emerald-600 to-blue-600 text-white">
        <div className="max-w-4xl mx-auto text-center">
          <h2 className="text-4xl font-bold mb-6">Sizin İçin Buradayız</h2>
          <p className="text-xl mb-8 opacity-90">
            Yurtdışı eğitim hayallerinizi gerçekleştirmek için profesyonel ekibimizle her zaman yanınızdayız
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="/contact" className="bg-white text-emerald-600 hover:bg-gray-100 px-8 py-4 rounded-lg font-bold transition-colors">
              Bizimle İletişime Geçin
            </a>
            <a href="/visa" className="border-2 border-white hover:bg-white hover:text-emerald-600 px-8 py-4 rounded-lg font-bold transition-colors">
              Başvuru Yapın
            </a>
          </div>
        </div>
      </section>
    </div>
  );
}
