"use client";

import { Card } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Input } from "@/components/ui/input";
import { Label } from "@/components/ui/label";
import { Badge } from "@/components/ui/badge";
import { Building, CreditCard, Upload, CheckCircle2, Copy } from "lucide-react";
import { useState } from "react";

export default function PaymentPage() {
  const [selectedFile, setSelectedFile] = useState<File | null>(null);

  const handleFileChange = (e: React.ChangeEvent<HTMLInputElement>) => {
    if (e.target.files?.[0]) {
      setSelectedFile(e.target.files[0]);
    }
  };

  const copyToClipboard = (text: string) => {
    navigator.clipboard.writeText(text);
    alert("Kopyalandı!");
  };

  return (
    <div className="pt-20 min-h-screen bg-gray-50">
      <div className="max-w-4xl mx-auto px-4 py-12">
        <div className="text-center mb-12">
          <Badge className="mb-4 bg-emerald-100 text-emerald-700">Ödeme</Badge>
          <h1 className="text-4xl font-bold mb-4">Ödeme Bilgileri</h1>
          <p className="text-gray-600">Başvurunuzu tamamlamak için ödeme yapın</p>
        </div>

        {/* Order Summary */}
        <Card className="p-8 mb-8">
          <h2 className="text-2xl font-bold mb-6">Sipariş Özeti</h2>
          <div className="space-y-4">
            <div className="flex justify-between py-3 border-b">
              <span className="text-gray-600">Hizmet</span>
              <span className="font-medium">İngiltere Öğrenci Vizesi</span>
            </div>
            <div className="flex justify-between py-3 border-b">
              <span className="text-gray-600">Hizmet Bedeli</span>
              <span className="font-medium">1.800₺</span>
            </div>
            <div className="flex justify-between py-3 border-b">
              <span className="text-gray-600">KDV (%18)</span>
              <span className="font-medium">324₺</span>
            </div>
            <div className="flex justify-between py-3 text-xl font-bold">
              <span>Toplam</span>
              <span className="text-emerald-600">2.124₺</span>
            </div>
          </div>
        </Card>

        {/* Bank Transfer */}
        <Card className="p-8 mb-8">
          <div className="flex items-center mb-6">
            <Building className="h-8 w-8 text-emerald-600 mr-3" />
            <h2 className="text-2xl font-bold">Banka Havalesi ile Ödeme</h2>
          </div>

          <div className="bg-blue-50 border-l-4 border-blue-600 p-6 mb-6">
            <p className="text-sm text-blue-900">
              <CheckCircle2 className="inline h-4 w-4 mr-2" />
              Ödemenizi yaptıktan sonra dekontunu yükleyiniz. Ödemeniz onaylandıktan sonra başvurunuz işleme alınacaktır.
            </p>
          </div>

          <div className="space-y-6">
            <div className="grid md:grid-cols-2 gap-6">
              <div className="space-y-2">
                <Label className="text-gray-600">Banka Adı</Label>
                <div className="flex items-center justify-between p-4 bg-gray-50 rounded-lg border">
                  <span className="font-medium">Ziraat Bankası</span>
                  <Button variant="ghost" size="sm" onClick={() => copyToClipboard("Ziraat Bankası")}>
                    <Copy className="h-4 w-4" />
                  </Button>
                </div>
              </div>

              <div className="space-y-2">
                <Label className="text-gray-600">Hesap Sahibi</Label>
                <div className="flex items-center justify-between p-4 bg-gray-50 rounded-lg border">
                  <span className="font-medium">Ucuza Vize Ltd. Şti.</span>
                  <Button variant="ghost" size="sm" onClick={() => copyToClipboard("Ucuza Vize Ltd. Şti.")}>
                    <Copy className="h-4 w-4" />
                  </Button>
                </div>
              </div>

              <div className="space-y-2">
                <Label className="text-gray-600">IBAN (TL)</Label>
                <div className="flex items-center justify-between p-4 bg-gray-50 rounded-lg border">
                  <span className="font-mono">TR00 0000 0000 0000 0000 0000 00</span>
                  <Button variant="ghost" size="sm" onClick={() => copyToClipboard("TR00 0000 0000 0000 0000 0000 00")}>
                    <Copy className="h-4 w-4" />
                  </Button>
                </div>
              </div>

              <div className="space-y-2">
                <Label className="text-gray-600">Tutar</Label>
                <div className="flex items-center justify-between p-4 bg-emerald-50 rounded-lg border border-emerald-200">
                  <span className="font-bold text-emerald-600 text-lg">2.124₺</span>
                  <Button variant="ghost" size="sm" onClick={() => copyToClipboard("2124")}>
                    <Copy className="h-4 w-4" />
                  </Button>
                </div>
              </div>
            </div>

            <div className="space-y-2">
              <Label className="text-gray-600">Açıklama (Lütfen mutlaka yazın)</Label>
              <div className="flex items-center justify-between p-4 bg-yellow-50 rounded-lg border border-yellow-200">
                <span className="font-medium">Başvuru No: #12345 - Ahmet Yılmaz</span>
                <Button variant="ghost" size="sm" onClick={() => copyToClipboard("#12345 - Ahmet Yılmaz")}>
                  <Copy className="h-4 w-4" />
                </Button>
              </div>
            </div>
          </div>
        </Card>

        {/* Upload Receipt */}
        <Card className="p-8">
          <div className="flex items-center mb-6">
            <Upload className="h-8 w-8 text-emerald-600 mr-3" />
            <h2 className="text-2xl font-bold">Dekont Yükle</h2>
          </div>

          <div className="space-y-6">
            <div>
              <Label htmlFor="receipt">Ödeme Dekontu</Label>
              <Input
                id="receipt"
                type="file"
                accept="image/*,.pdf"
                onChange={handleFileChange}
                className="mt-2"
              />
              {selectedFile && (
                <p className="text-sm text-green-600 mt-2">
                  <CheckCircle2 className="inline h-4 w-4 mr-1" />
                  {selectedFile.name} yüklendi
                </p>
              )}
            </div>

            <div>
              <Label htmlFor="referenceNo">Referans / İşlem No (Opsiyonel)</Label>
              <Input
                id="referenceNo"
                placeholder="123456789"
                className="mt-2"
              />
            </div>

            <div>
              <Label htmlFor="notes">Not (Opsiyonel)</Label>
              <Input
                id="notes"
                placeholder="Ek bilgiler..."
                className="mt-2"
              />
            </div>

            <Button className="w-full bg-emerald-600 hover:bg-emerald-700 py-6 text-lg">
              Ödeme Bilgilerini Gönder
            </Button>
          </div>
        </Card>

        <div className="mt-8 p-6 bg-gray-100 rounded-lg">
          <p className="text-sm text-gray-700 text-center">
            <CheckCircle2 className="inline h-4 w-4 mr-1 text-emerald-600" />
            Ödemeniz 1-2 iş günü içinde kontrol edilecek ve onaylanacaktır.
          </p>
        </div>
      </div>
    </div>
  );
}
