import { Card } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Badge } from "@/components/ui/badge";
import { Plane, Clock, CheckCircle2, FileText } from "lucide-react";
import Link from "next/link";

const countries = [
  { name: "Amerika", flag: "🇺🇸", visaTypes: ["Turist", "Öğrenci", "İş"], price: "2.500₺" },
  { name: "İngiltere", flag: "🇬🇧", visaTypes: ["Turist", "Öğrenci", "İş"], price: "1.800₺" },
  { name: "Kanada", flag: "🇨🇦", visaTypes: ["Turist", "Öğrenci", "İş"], price: "2.200₺" },
  { name: "Almanya", flag: "🇩🇪", visaTypes: ["Turist", "Öğrenci", "İş"], price: "1.500₺" },
  { name: "Fransa", flag: "🇫🇷", visaTypes: ["Turist", "Öğrenci", "İş"], price: "1.500₺" },
  { name: "Avustralya", flag: "🇦🇺", visaTypes: ["Turist", "Öğrenci", "İş"], price: "2.000₺" },
  { name: "İspanya", flag: "🇪🇸", visaTypes: ["Turist", "Öğrenci"], price: "1.400₺" },
  { name: "İtalya", flag: "🇮🇹", visaTypes: ["Turist", "Öğrenci"], price: "1.400₺" },
];

export default function VisaPage() {
  return (
    <div className="pt-20">
      <section className="bg-gradient-to-br from-emerald-50 to-blue-50 py-20 px-4">
        <div className="max-w-7xl mx-auto text-center">
          <Badge className="mb-6 bg-emerald-100 text-emerald-700 hover:bg-emerald-200">
            Vize İşlemleri
          </Badge>
          <h1 className="text-5xl md:text-6xl font-bold mb-6">
            Vize Başvuru Hizmetleri
          </h1>
          <p className="text-xl text-gray-600 max-w-3xl mx-auto">
            50'den fazla ülkeye vize başvurusu yapın. Uzman ekibimiz tüm süreçte yanınızda.
          </p>
        </div>
      </section>

      <section className="py-16 px-4 bg-white">
        <div className="max-w-7xl mx-auto">
          <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-6 mb-16">
            {[
              { icon: Clock, title: "7-14 Gün", desc: "Ortalama İşlem Süresi" },
              { icon: CheckCircle2, title: "%98", desc: "Onay Oranı" },
              { icon: FileText, title: "Evrak Kontrolü", desc: "Ücretsiz Danışmanlık" },
              { icon: Plane, title: "50+ Ülke", desc: "Vize Hizmeti" },
            ].map((item, idx) => (
              <Card key={idx} className="p-6 text-center border-2">
                <item.icon className="h-10 w-10 text-emerald-600 mx-auto mb-3" />
                <h3 className="font-bold text-lg mb-1">{item.title}</h3>
                <p className="text-sm text-gray-600">{item.desc}</p>
              </Card>
            ))}
          </div>

          <h2 className="text-3xl font-bold mb-8 text-center">Popüler Ülkeler</h2>
          <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-6">
            {countries.map((country) => (
              <Card key={country.name} className="p-6 hover:shadow-xl transition-all border-2">
                <div className="text-5xl mb-4 text-center">{country.flag}</div>
                <h3 className="text-xl font-bold mb-3 text-center">{country.name}</h3>
                <div className="space-y-2 mb-4">
                  {country.visaTypes.map((type) => (
                    <div key={type} className="flex items-center text-sm">
                      <CheckCircle2 className="h-4 w-4 text-emerald-600 mr-2" />
                      <span>{type} Vizesi</span>
                    </div>
                  ))}
                </div>
                <div className="text-2xl font-bold text-emerald-600 mb-4 text-center">
                  {country.price}
                  <span className="text-sm text-gray-500">'den başlayan</span>
                </div>
                <Link href="/visa/apply">
                  <Button className="w-full bg-emerald-600 hover:bg-emerald-700">
                    Başvuru Yap
                  </Button>
                </Link>
              </Card>
            ))}
          </div>
        </div>
      </section>

      <section className="py-16 px-4 bg-gray-50">
        <div className="max-w-4xl mx-auto">
          <h2 className="text-3xl font-bold mb-8 text-center">Vize Başvuru Süreci</h2>
          <div className="space-y-6">
            {[
              { step: 1, title: "Ülke ve Vize Türü Seçimi", desc: "İstediğiniz ülke ve vize türünü seçin" },
              { step: 2, title: "Evrakların Hazırlanması", desc: "Gerekli evrak listesini inceleyin ve hazırlayın" },
              { step: 3, title: "Online Başvuru", desc: "Formu doldurun ve evrakları yükleyin" },
              { step: 4, title: "Ödeme", desc: "Banka havalesi ile ödemenizi gerçekleştirin" },
              { step: 5, title: "Randevu", desc: "Konsolosluk randevunuzu alın" },
              { step: 6, title: "Takip", desc: "Başvurunuzu online sistemden takip edin" },
            ].map((item) => (
              <Card key={item.step} className="p-6 border-l-4 border-l-emerald-600">
                <div className="flex items-start">
                  <div className="bg-emerald-600 text-white rounded-full w-10 h-10 flex items-center justify-center font-bold mr-4 flex-shrink-0">
                    {item.step}
                  </div>
                  <div>
                    <h3 className="font-bold text-lg mb-1">{item.title}</h3>
                    <p className="text-gray-600">{item.desc}</p>
                  </div>
                </div>
              </Card>
            ))}
          </div>
        </div>
      </section>
    </div>
  );
}
