import Link from "next/link";
import { Plane, Mail, Phone, MapPin, Facebook, Twitter, Instagram, Linkedin } from "lucide-react";

export function Footer() {
  return (
    <footer className="bg-gray-900 text-gray-300">
      <div className="max-w-7xl mx-auto px-4 py-16">
        <div className="grid md:grid-cols-4 gap-12">
          <div>
            <div className="flex items-center space-x-2 mb-4">
              <div className="bg-gradient-to-r from-emerald-600 to-blue-600 p-2 rounded-lg">
                <Plane className="h-6 w-6 text-white" />
              </div>
              <span className="text-2xl font-bold text-white">Ucuza Vize</span>
            </div>
            <p className="text-sm leading-relaxed">
              Yurtdışı eğitim hayallerinizi en uygun fiyatlarla gerçeğe dönüştürüyoruz.
            </p>
          </div>

          <div>
            <h3 className="text-white font-bold mb-4">Hızlı Linkler</h3>
            <ul className="space-y-2">
              {["Ana Sayfa", "Vize İşlemleri", "Dil Okulları", "Hakkımızda", "Blog"].map((item) => (
                <li key={item}><Link href="#" className="hover:text-emerald-400 transition-colors">{item}</Link></li>
              ))}
            </ul>
          </div>

          <div>
            <h3 className="text-white font-bold mb-4">Hizmetler</h3>
            <ul className="space-y-2">
              {["Turist Vizesi", "Öğrenci Vizesi", "İş Vizesi", "Dil Okulu Kayıt", "Konaklama"].map((item) => (
                <li key={item}><Link href="#" className="hover:text-emerald-400 transition-colors">{item}</Link></li>
              ))}
            </ul>
          </div>

          <div>
            <h3 className="text-white font-bold mb-4">İletişim</h3>
            <ul className="space-y-3">
              <li className="flex items-start"><Phone className="h-5 w-5 mr-2 mt-0.5 flex-shrink-0" /><span>+90 212 XXX XX XX</span></li>
              <li className="flex items-start"><Mail className="h-5 w-5 mr-2 mt-0.5 flex-shrink-0" /><span>info@ucuzavize.com</span></li>
              <li className="flex items-start"><MapPin className="h-5 w-5 mr-2 mt-0.5 flex-shrink-0" /><span>İstanbul, Türkiye</span></li>
            </ul>
            <div className="flex space-x-4 mt-6">
              {[Facebook, Twitter, Instagram, Linkedin].map((Icon, idx) => (
                <a key={idx} href="#" className="hover:text-emerald-400 transition-colors"><Icon className="h-5 w-5" /></a>
              ))}
            </div>
          </div>
        </div>

        <div className="border-t border-gray-800 mt-12 pt-8 text-center text-sm">
          <p>&copy; 2025 Ucuza Vize. Tüm hakları saklıdır.</p>
        </div>
      </div>
    </footer>
  );
}
